<?php

namespace UVDesk\CommunityPackages\UVDesk\CustomFields\Repository;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Query;
use UVDesk\CommunityPackages\UVDesk\CustomFields\Entity\CustomFields;
use UVDesk\CommunityPackages\UVDesk\CustomFields\Entity\TicketCustomFieldsValues;
use Webkul\UVDeskCoreFrameWorkBundle\Entity\Ticket;
use Webkul\UVDeskCoreFrameWorkBundle\Entity\User;

/**
 * TaskThreadRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class CustomFieldsRepository extends EntityRepository
{
    public function getSiblingCustomFieldRecords(CustomFields $customField, User $customer) 
    {
        $queryBuilder = $this->getEntityManager()->createQueryBuilder()
            ->select('tcfv')
            ->from(TicketCustomFieldsValues::class, 'tcfv')
            ->leftJoin('tcfv.ticketCustomFieldsValues', 'cf')
            ->leftJoin('tcfv.ticketCustomFieldValueValues', 'cfv')
            ->leftJoin('tcfv.ticket', 't')
            ->where('tcfv.ticketCustomFieldsValues = :customField')
            ->setParameter('customField', $customField)
            ->andWhere('t.customer = :customer')
            ->setParameter('customer', $customer)
            ->orderBy('t.createdAt', 'DESC');

        $siblingCustomFieldCollection = $queryBuilder->getQuery()->getResult();
        return (!empty($siblingCustomFieldCollection)) ? $siblingCustomFieldCollection : [];
    }

    public function getCustomFieldValueByTicketAndCF(Ticket $ticket, $customFieldId)
    {
        $queryBuilder = $this->getEntityManager()->createQueryBuilder()
            ->select('tcfv.value, cf.fieldType')
            ->from(TicketCustomFieldsValues::class, 'tcfv')
            ->leftJoin('tcfv.ticketCustomFieldsValues', 'cf')
            ->leftJoin('tcfv.ticketCustomFieldValueValues', 'cfv')
            ->leftJoin('tcfv.ticket', 't')
            ->where('cf.id = :customFieldId')
            ->setParameter('customFieldId', $customFieldId)
            ->andWhere('t = :ticket')
            ->setParameter('ticket', $ticket)
            ->orderBy('t.createdAt', 'DESC');

            $cfv = $queryBuilder->getQuery()->getResult();
            if(count($cfv)) {
                $cfv = reset($cfv);
                $value = null;
                if( in_array($cfv['fieldType'], ['select', 'radio', 'checkbox']) ) {
                    $value = json_decode($cfv['value'], true);
                } else {
                    $value = trim($cfv['value'], '"');
                }
            } else {
                $value = null;
            }

            return $value;
    }
    
    public function findAllArray() {

        return $this->createQueryBuilder('cf')
                    ->getQuery()
                    ->getResult(Query::HYDRATE_ARRAY);
    }
}
