<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20240810063751 extends AbstractMigration
{
    public function getDescription() : string
    {
        return '';
    }

    public function up(Schema $schema) : void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('CREATE TABLE microsoft_account (id INT AUTO_INCREMENT NOT NULL, microsoft_app_id INT NOT NULL, name VARCHAR(255) NOT NULL, email VARCHAR(255) NOT NULL, credentials LONGTEXT NOT NULL, INDEX IDX_B05D6E45C5B953D8 (microsoft_app_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE microsoft_app (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(255) NOT NULL, tenant_id VARCHAR(255) NOT NULL, client_id VARCHAR(255) NOT NULL, client_secret VARCHAR(255) NOT NULL, api_permissions LONGTEXT NOT NULL COMMENT \'(DC2Type:array)\', is_verified TINYINT(1) NOT NULL, is_enabled TINYINT(1) NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('ALTER TABLE microsoft_account ADD CONSTRAINT FK_B05D6E45C5B953D8 FOREIGN KEY (microsoft_app_id) REFERENCES microsoft_app (id) ON DELETE CASCADE');
        $this->addSql('DROP TABLE uv_api_access_credentials');
        $this->addSql('ALTER TABLE uv_ticket ADD outlook_conversation_id LONGTEXT DEFAULT NULL');
    }

    public function down(Schema $schema) : void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('ALTER TABLE microsoft_account DROP FOREIGN KEY FK_B05D6E45C5B953D8');
        $this->addSql('CREATE TABLE uv_api_access_credentials (id INT AUTO_INCREMENT NOT NULL, user_id INT NOT NULL, name VARCHAR(255) CHARACTER SET utf8mb4 NOT NULL COLLATE `utf8mb4_unicode_ci`, token VARCHAR(255) CHARACTER SET utf8mb4 NOT NULL COLLATE `utf8mb4_unicode_ci`, created_on DATETIME NOT NULL, is_enabled TINYINT(1) DEFAULT \'1\' NOT NULL, is_expired TINYINT(1) DEFAULT \'0\' NOT NULL, INDEX IDX_31DBD20EA76ED395 (user_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB COMMENT = \'\' ');
        $this->addSql('ALTER TABLE uv_api_access_credentials ADD CONSTRAINT FK_31DBD20EA76ED395 FOREIGN KEY (user_id) REFERENCES uv_user (id) ON UPDATE NO ACTION ON DELETE CASCADE');
        $this->addSql('DROP TABLE microsoft_account');
        $this->addSql('DROP TABLE microsoft_app');
        $this->addSql('ALTER TABLE uv_ticket DROP outlook_conversation_id');
    }
}
