<?php

declare(strict_types=1);

namespace PackageVersions;

use Composer\InstalledVersions;
use OutOfBoundsException;

class_exists(InstalledVersions::class);

/**
 * This class is generated by composer/package-versions-deprecated, specifically by
 * @see \PackageVersions\Installer
 *
 * This file is overwritten at every run of `composer install` or `composer update`.
 *
 * @deprecated in favor of the Composer\InstalledVersions class provided by Composer 2. Require composer-runtime-api:^2 to ensure it is present.
 */
final class Versions
{
    /**
     * @deprecated please use {@see self::rootPackageName()} instead.
     *             This constant will be removed in version 2.0.0.
     */
    const ROOT_PACKAGE_NAME = 'uvdesk/community-skeleton';

    /**
     * Array of all available composer packages.
     * Dont read this array from your calling code, but use the \PackageVersions\Versions::getVersion() method instead.
     *
     * @var array<string, string>
     * @internal
     */
    const VERSIONS          = array (
  'carbonphp/carbon-doctrine-types' => '1.0.0@3c430083d0b41ceed84ecccf9dac613241d7305d',
  'composer/package-versions-deprecated' => '1.11.99.5@b4f54f74ef3453349c24a845d22392cd31e65f1d',
  'doctrine/annotations' => '1.14.4@253dca476f70808a5aeed3a47cc2cc88c5cab915',
  'doctrine/cache' => '2.2.0@1ca8f21980e770095a31456042471a57bc4c68fb',
  'doctrine/collections' => '2.2.2@d8af7f248c74f195f7347424600fd9e17b57af59',
  'doctrine/common' => '3.4.5@6c8fef961f67b8bc802ce3e32e3ebd1022907286',
  'doctrine/data-fixtures' => '1.6.7@ae4e845decbe177348fdbecd04331f4fb96aa301',
  'doctrine/dbal' => '2.13.9@c480849ca3ad6706a39c970cdfe6888fa8a058b8',
  'doctrine/deprecations' => '1.1.3@dfbaa3c2d2e9a9df1118213f3b8b0c597bb99fab',
  'doctrine/doctrine-bundle' => '2.7.2@22d53b2c5ad03929628fb4a928b01135585b7179',
  'doctrine/doctrine-fixtures-bundle' => '3.4.5@5988484f79362cd7d06564bd11be7ce622e08c87',
  'doctrine/doctrine-migrations-bundle' => '2.2.3@0a081b55a88259a887af7be654743a8c5f703e99',
  'doctrine/event-manager' => '1.2.0@95aa4cb529f1e96576f3fda9f5705ada4056a520',
  'doctrine/inflector' => '2.0.10@5817d0659c5b50c9b950feb9af7b9668e2c436bc',
  'doctrine/instantiator' => '2.0.0@c6222283fa3f4ac679f8b9ced9a4e23f163e80d0',
  'doctrine/lexer' => '2.1.1@861c870e8b75f7c8f69c146c7f89cc1c0f1b49b6',
  'doctrine/migrations' => '2.3.5@28d92a34348fee5daeb80879e56461b2e862fc05',
  'doctrine/orm' => '2.20.0@8ed6c2234aba019f9737a6bcc9516438e62da27c',
  'doctrine/persistence' => '3.4.0@0ea965320cec355dba75031c1b23d4c78362e3ff',
  'doctrine/sql-formatter' => '1.5.1@b784cbde727cf806721451dde40eff4fec3bbe86',
  'egulias/email-validator' => '4.0.2@ebaaf5be6c0286928352e054f2d5125608e5405e',
  'friendsofphp/proxy-manager-lts' => 'v1.0.18@2c8a6cffc3220e99352ad958fe7cf06bf6f7690f',
  'google/recaptcha' => '1.3.0@d59a801e98a4e9174814a6d71bbc268dff1202df',
  'guzzlehttp/psr7' => '2.7.0@a70f5c95fb43bc83f07c9c948baa0dc1829bf201',
  'iamcal/lib_autolink' => 'v1.9@6a9e44d17f836806301b40723af673971a1a5112',
  'illuminate/cache' => 'v8.83.27@7ae5b3661413dad7264b5c69037190d766bae50f',
  'illuminate/collections' => 'v8.83.27@705a4e1ef93cd492c45b9b3e7911cccc990a07f4',
  'illuminate/contracts' => 'v8.83.27@5e0fd287a1b22a6b346a9f7cd484d8cf0234585d',
  'illuminate/filesystem' => 'v8.83.27@73db3e9a233ed587ba54f52ab8580f3c7bc872b2',
  'illuminate/macroable' => 'v8.83.27@aed81891a6e046fdee72edd497f822190f61c162',
  'illuminate/support' => 'v8.83.27@1c79242468d3bbd9a0f7477df34f9647dde2a09b',
  'intervention/image' => '2.7.2@04be355f8d6734c826045d02a1079ad658322dad',
  'intervention/imagecache' => '2.6.0@86136575a62d3634b51f196a998fce4a583b49bb',
  'knplabs/knp-components' => 'v3.6.0@145d74f3fbb24619a60a6f7e54aa4bd10862b07a',
  'knplabs/knp-paginator-bundle' => 'v5.9.0@7879916a8af4f4d4668535cb0b71f55cc416da66',
  'laminas/laminas-code' => '4.15.1@877ad42fe9c164785182fca8afa3f416a056884d',
  'maennchen/zipstream-php' => '3.1.1@6187e9cc4493da94b9b63eb2315821552015fca9',
  'markbaker/complex' => '3.0.2@95c56caa1cf5c766ad6d65b6344b807c1e8405b9',
  'markbaker/matrix' => '3.0.1@728434227fe21be27ff6d86621a1b13107a2562c',
  'monolog/monolog' => '2.9.3@a30bfe2e142720dfa990d0a7e573997f5d884215',
  'nesbot/carbon' => '2.72.5@afd46589c216118ecd48ff2b95d77596af1e57ed',
  'opis/closure' => '3.6.3@3d81e4309d2a927abbe66df935f4bb60082805ad',
  'php-mime-mail-parser/php-mime-mail-parser' => '7.1.2@81d84bbc6a73b913110e155e98059526825c7ee3',
  'phpdocumentor/reflection-common' => '2.2.0@1d01c49d4ed62f25aa84a747ad35d5a16924662b',
  'phpdocumentor/reflection-docblock' => '5.5.1@0c70d2c566e899666f367ab7b80986beb3581e6f',
  'phpdocumentor/type-resolver' => '1.10.0@679e3ce485b99e84c775d28e2e96fade9a7fb50a',
  'phpoffice/phpspreadsheet' => '3.4.0@eec07c20b51cc785295a6feef81ada7feda755e7',
  'phpstan/phpdoc-parser' => '1.33.0@82a311fd3690fb2bf7b64d5c98f912b3dd746140',
  'psr/cache' => '2.0.0@213f9dbc5b9bfbc4f8db86d2838dc968752ce13b',
  'psr/clock' => '1.0.0@e41a24703d4560fd0acb709162f73b8adfc3aa0d',
  'psr/container' => '1.1.2@513e0666f7216c7459170d56df27dfcefe1689ea',
  'psr/event-dispatcher' => '1.0.0@dbefd12671e8a14ec7f180cab83036ed26714bb0',
  'psr/http-client' => '1.0.3@bb5906edc1c324c9a05aa0873d40117941e5fa90',
  'psr/http-factory' => '1.1.0@2b4765fddfe3b508ac62f829e852b1501d3f6e8a',
  'psr/http-message' => '2.0@402d35bcb92c70c026d1a6a9883f06b2ead23d71',
  'psr/link' => '1.1.1@846c25f58a1f02b93a00f2404e3626b6bf9b7807',
  'psr/log' => '2.0.0@ef29f6d262798707a9edd554e2b82517ef3a9376',
  'psr/simple-cache' => '1.0.1@408d5eafb83c57f6365a3ca330ff23aa4a5fa39b',
  'ralouphie/getallheaders' => '3.0.3@120b605dfeb996808c31b6477290a714d356e822',
  'sensio/framework-extra-bundle' => 'v6.2.10@2f886f4b31f23c76496901acaedfedb6936ba61f',
  'symfony/asset' => 'v5.4.45@b7a18eaff1d717c321b4f13403413f8815bf9cb0',
  'symfony/cache' => 'v5.4.46@0fe08ee32cec2748fbfea10c52d3ee02049e0f6b',
  'symfony/cache-contracts' => 'v2.5.3@fee6db04d913094e2fb55ff8e7db5685a8134463',
  'symfony/config' => 'v5.4.46@977c88a02d7d3f16904a81907531b19666a08e78',
  'symfony/console' => 'v5.4.46@fb0d4760e7147d81ab4d9e2d57d56268261b4e4e',
  'symfony/dependency-injection' => 'v5.4.45@0c199da64bb27e4216ccccb83f451e2ec66b3c4b',
  'symfony/deprecation-contracts' => 'v3.5.0@0e0d29ce1f20deffb4ab1b016a7257c4f1e789a1',
  'symfony/doctrine-bridge' => 'v5.4.46@22f9d7c3724ae10656797f10d1cb926daa612845',
  'symfony/dotenv' => 'v5.4.45@4cb5f06e55b7c58122f8ccb09c67d4e2f5eab32b',
  'symfony/error-handler' => 'v5.4.46@d19ede7a2cafb386be9486c580649d0f9e3d0363',
  'symfony/event-dispatcher' => 'v5.4.45@72982eb416f61003e9bb6e91f8b3213600dcf9e9',
  'symfony/event-dispatcher-contracts' => 'v3.5.0@8f93aec25d41b72493c6ddff14e916177c9efc50',
  'symfony/expression-language' => 'v5.4.45@a784b66edc4c151eb05076d04707906ee2c209a9',
  'symfony/filesystem' => 'v5.4.45@57c8294ed37d4a055b77057827c67f9558c95c54',
  'symfony/finder' => 'v5.4.45@63741784cd7b9967975eec610b256eed3ede022b',
  'symfony/flex' => 'v2.4.7@92f4fba342161ff36072bd3b8e0b3c6c23160402',
  'symfony/form' => 'v5.4.45@c1974a723cdee8a273cb49ce13fada5c1667706a',
  'symfony/framework-bundle' => 'v5.4.45@3d70f14176422d4d8ee400b6acae4e21f7c25ca2',
  'symfony/http-client' => 'v5.4.46@ebcaeeafc48b69f497f82b9700ddf54bfe975f71',
  'symfony/http-client-contracts' => 'v2.5.3@e5cc97c2b4a4db0ba26bebc154f1426e3fd1d2f1',
  'symfony/http-foundation' => 'v5.4.46@168b77c71e6f02d8fc479db78beaf742a37d3cab',
  'symfony/http-kernel' => 'v5.4.46@492ce57430d44e28b30b2c76724bef31dcb73b3e',
  'symfony/intl' => 'v5.4.46@d74763310045ccf2bf485549f8ba942184e31087',
  'symfony/mailer' => 'v5.4.45@f732e1fafdf0f4a2d865e91f1018aaca174aeed9',
  'symfony/mime' => 'v5.4.45@8c1b9b3e5b52981551fc6044539af1d974e39064',
  'symfony/monolog-bridge' => 'v5.4.45@cf7d75d4d64a41fbb1c0e92301bec404134fa84b',
  'symfony/monolog-bundle' => 'v3.10.0@414f951743f4aa1fd0f5bf6a0e9c16af3fe7f181',
  'symfony/notifier' => 'v5.4.45@d3c9c31224684ab10a4b9614aaf21985b2e0d41b',
  'symfony/options-resolver' => 'v5.4.45@74e5b6f0db3e8589e6cfd5efb317a1fc2bb52fb6',
  'symfony/password-hasher' => 'v5.4.45@6c5993b24505f98b90ca4896448012bbec54c7c8',
  'symfony/polyfill-intl-grapheme' => 'v1.31.0@b9123926e3b7bc2f98c02ad54f6a4b02b91a8abe',
  'symfony/polyfill-intl-icu' => 'v1.31.0@d80a05e9904d2c2b9b95929f3e4b5d3a8f418d78',
  'symfony/polyfill-intl-idn' => 'v1.31.0@c36586dcf89a12315939e00ec9b4474adcb1d773',
  'symfony/polyfill-intl-normalizer' => 'v1.31.0@3833d7255cc303546435cb650316bff708a1c75c',
  'symfony/polyfill-mbstring' => 'v1.31.0@85181ba99b2345b0ef10ce42ecac37612d9fd341',
  'symfony/polyfill-php73' => 'v1.31.0@0f68c03565dcaaf25a890667542e8bd75fe7e5bb',
  'symfony/polyfill-php80' => 'v1.31.0@60328e362d4c2c802a54fcbf04f9d3fb892b4cf8',
  'symfony/polyfill-php81' => 'v1.31.0@4a4cfc2d253c21a5ad0e53071df248ed48c6ce5c',
  'symfony/process' => 'v5.4.46@01906871cb9b5e3cf872863b91aba4ec9767daf4',
  'symfony/property-access' => 'v5.4.45@111e7ed617509f1a9139686055d234aad6e388e0',
  'symfony/property-info' => 'v5.4.45@cec75362b20263758c9c7af4c2f9af82614195ae',
  'symfony/proxy-manager-bridge' => 'v5.4.45@e96cd37f3de0b75ff32f6b79c180ba77c4037eec',
  'symfony/routing' => 'v5.4.45@986597b3d1c86ecefe094c0c236a9e9ad22756f2',
  'symfony/runtime' => 'v5.4.46@242b4d773c004fa258e1b412f3f49fc2ac78353a',
  'symfony/security-bundle' => 'v5.4.45@d6081d1b9118f944df90bb77444a8617eba01542',
  'symfony/security-core' => 'v5.4.45@2d324971f4a241cf538502e14f15ad32f2b16b9b',
  'symfony/security-csrf' => 'v5.4.45@28dcafc3220f12264bb2aabe2389a2163458c1f4',
  'symfony/security-guard' => 'v5.4.45@f3da3dbec38aaedaf287ffeb4e3a90994af37faa',
  'symfony/security-http' => 'v5.4.46@7152f0e4e292719cdeb8306076448036e025569b',
  'symfony/serializer' => 'v5.4.45@460c5df9fb6c39d10d5b7f386e4feae4b6370221',
  'symfony/service-contracts' => 'v2.5.3@a2329596ddc8fd568900e3fc76cba42489ecc7f3',
  'symfony/stopwatch' => 'v5.4.45@fb2c199cf302eb207f8c23e7ee174c1c31a5c004',
  'symfony/string' => 'v5.4.45@7f6807add88b1e2635f3c6de5e1ace631ed7cad2',
  'symfony/translation' => 'v5.4.45@98f26acc99341ca4bab345fb14d7b1d7cb825bed',
  'symfony/translation-contracts' => 'v2.5.3@b0073a77ac0b7ea55131020e87b1e3af540f4664',
  'symfony/twig-bridge' => 'v5.4.45@b3d3738b4be14bf1a4544a6faeed89463fe8b60e',
  'symfony/twig-bundle' => 'v5.4.45@e1ca56e1dc7791eb19f0aff71d3d94e6a91cc8f9',
  'symfony/validator' => 'v5.4.46@9849c2cae17964a42a77df6823ac90414e2b451d',
  'symfony/var-dumper' => 'v5.4.46@f51f11e4fc5ca24fa0defcdf4df027078950b9e0',
  'symfony/var-exporter' => 'v6.4.13@0f605f72a363f8743001038a176eeb2a11223b51',
  'symfony/web-link' => 'v5.4.45@5b71baea258dbbe2a3627cb11c1721e8a2216a55',
  'symfony/yaml' => 'v5.4.45@a454d47278cc16a5db371fe73ae66a78a633371e',
  'twig/extra-bundle' => 'v3.13.0@21a9a7aa9f79d4493bb6fed4eb2794339f9551f5',
  'twig/twig' => 'v3.14.2@0b6f9d8370bb3b7f1ce5313ed8feb0fafd6e399a',
  'uvdesk/api-bundle' => 'v1.1.2@1bef316db7530ccce2df094d84c69dc0699284b5',
  'uvdesk/automation-bundle' => 'dev-master@f52602a2adc47dffc175f5f5c2b1073dbbc15fa3',
  'uvdesk/core-framework' => 'dev-master@29cc49a7a5711d2a42cc3395a41446b250705be6',
  'uvdesk/extension-framework' => 'dev-master@d85c265787d66367371542903d0cf0dd5892ae20',
  'uvdesk/mailbox-component' => 'dev-master@4935437627e260f7736bfa80d7c4acf09f786a08',
  'uvdesk/support-center-bundle' => 'dev-master@faedbeaa02654ed010489a9a5c23efceab951db4',
  'voku/portable-ascii' => '1.6.1@87337c91b9dfacee02452244ee14ab3c43bc485a',
  'webmozart/assert' => '1.11.0@11cb2199493b2f8a3b53e7f19068fc6aac760991',
  'myclabs/deep-copy' => '1.12.1@123267b2c49fbf30d78a7b2d333f6be754b94845',
  'nikic/php-parser' => 'v4.19.4@715f4d25e225bc47b293a8b997fe6ce99bf987d2',
  'phar-io/manifest' => '2.0.4@54750ef60c58e43759730615a392c31c80e23176',
  'phar-io/version' => '3.2.1@4f7fd7836c6f332bb2933569e566a0d6c4cbed74',
  'phpunit/php-code-coverage' => '9.2.32@85402a822d1ecf1db1096959413d35e1c37cf1a5',
  'phpunit/php-file-iterator' => '3.0.6@cf1c2e7c203ac650e352f4cc675a7021e7d1b3cf',
  'phpunit/php-invoker' => '3.1.1@5a10147d0aaf65b58940a0b72f71c9ac0423cc67',
  'phpunit/php-text-template' => '2.0.4@5da5f67fc95621df9ff4c4e5a84d6a8a2acf7c28',
  'phpunit/php-timer' => '5.0.3@5a63ce20ed1b5bf577850e2c4e87f4aa902afbd2',
  'phpunit/phpunit' => '9.6.21@de6abf3b6f8dd955fac3caad3af7a9504e8c2ffa',
  'sebastian/cli-parser' => '1.0.2@2b56bea83a09de3ac06bb18b92f068e60cc6f50b',
  'sebastian/code-unit' => '1.0.8@1fc9f64c0927627ef78ba436c9b17d967e68e120',
  'sebastian/code-unit-reverse-lookup' => '2.0.3@ac91f01ccec49fb77bdc6fd1e548bc70f7faa3e5',
  'sebastian/comparator' => '4.0.8@fa0f136dd2334583309d32b62544682ee972b51a',
  'sebastian/complexity' => '2.0.3@25f207c40d62b8b7aa32f5ab026c53561964053a',
  'sebastian/diff' => '4.0.6@ba01945089c3a293b01ba9badc29ad55b106b0bc',
  'sebastian/environment' => '5.1.5@830c43a844f1f8d5b7a1f6d6076b784454d8b7ed',
  'sebastian/exporter' => '4.0.6@78c00df8f170e02473b682df15bfcdacc3d32d72',
  'sebastian/global-state' => '5.0.7@bca7df1f32ee6fe93b4d4a9abbf69e13a4ada2c9',
  'sebastian/lines-of-code' => '1.0.4@e1e4a170560925c26d424b6a03aed157e7dcc5c5',
  'sebastian/object-enumerator' => '4.0.4@5c9eeac41b290a3712d88851518825ad78f45c71',
  'sebastian/object-reflector' => '2.0.4@b4f479ebdbf63ac605d183ece17d8d7fe49c15c7',
  'sebastian/recursion-context' => '4.0.5@e75bd0f07204fec2a0af9b0f3cfe97d05f92efc1',
  'sebastian/resource-operations' => '3.0.4@05d5692a7993ecccd56a03e40cd7e5b09b1d404e',
  'sebastian/type' => '3.2.1@75e2c2a32f5e0b3aef905b9ed0b179b953b3d7c7',
  'sebastian/version' => '3.0.2@c6c1022351a901512170118436c764e473f6de8c',
  'symfony/browser-kit' => 'v5.4.45@03cce39764429e07fbab9b989a1182a24578341d',
  'symfony/css-selector' => 'v5.4.45@4f7f3c35fba88146b56d0025d20ace3f3901f097',
  'symfony/debug-bundle' => 'v5.4.45@653c7629d036ef24ac5de54a157aecdc400d2570',
  'symfony/dom-crawler' => 'v5.4.45@89647a57db280f9f93c27271fea58babb77bb473',
  'symfony/maker-bundle' => 'v1.50.0@a1733f849b999460c308e66f6392fb09b621fa86',
  'symfony/phpunit-bridge' => 'v7.1.6@c6b9d8f52d3e276bedb49612aa4a2a046171287f',
  'symfony/web-profiler-bundle' => 'v5.4.46@8ce2ad95670ad50b92eb6456836d15d0cc0eeff8',
  'theseer/tokenizer' => '1.2.3@737eda637ed5e28c3413cb1ebe8bb52cbf1ca7a2',
  'symfony/polyfill-ctype' => '*@',
  'symfony/polyfill-iconv' => '*@',
  'symfony/polyfill-php72' => '*@',
  'uvdesk/community-skeleton' => '1.0.0+no-version-set@',
);

    private function __construct()
    {
    }

    /**
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function rootPackageName() : string
    {
        if (!self::composer2ApiUsable()) {
            return self::ROOT_PACKAGE_NAME;
        }

        return InstalledVersions::getRootPackage()['name'];
    }

    /**
     * @throws OutOfBoundsException If a version cannot be located.
     *
     * @psalm-param key-of<self::VERSIONS> $packageName
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function getVersion(string $packageName): string
    {
        if (self::composer2ApiUsable()) {
            return InstalledVersions::getPrettyVersion($packageName)
                . '@' . InstalledVersions::getReference($packageName);
        }

        if (isset(self::VERSIONS[$packageName])) {
            return self::VERSIONS[$packageName];
        }

        throw new OutOfBoundsException(
            'Required package "' . $packageName . '" is not installed: check your ./vendor/composer/installed.json and/or ./composer.lock files'
        );
    }

    private static function composer2ApiUsable(): bool
    {
        if (!class_exists(InstalledVersions::class, false)) {
            return false;
        }

        if (method_exists(InstalledVersions::class, 'getAllRawData')) {
            $rawData = InstalledVersions::getAllRawData();
            if (count($rawData) === 1 && count($rawData[0]) === 0) {
                return false;
            }
        } else {
            $rawData = InstalledVersions::getRawData();
            if ($rawData === null || $rawData === []) {
                return false;
            }
        }

        return true;
    }
}
