<?php

namespace Webkul\UVDesk\CoreFrameworkBundle\Workflow\Actions\Ticket;

use Webkul\UVDesk\CoreFrameworkBundle\Entity\Ticket;
use Webkul\UVDesk\AutomationBundle\Workflow\FunctionalGroup;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Webkul\UVDesk\AutomationBundle\Workflow\Action as WorkflowAction;

class DueDate extends WorkflowAction
{
    // Unique ID for the action
    public static function getId()
    {
        return 'uvdesk.ticket.set_due_days';
    }

    // Description for the action
    public static function getDescription()
    {
        return "Set Due Days";
    }

    // Functional group to which this action belongs
    public static function getFunctionalGroup()
    {
        return FunctionalGroup::TICKET;
    }

    // Define the options available for this action
    public static function getOptions(ContainerInterface $container)
    {
        return [
            [
                'type' => 'text', // Input type as text
                'label' => 'Due Days', // Label for the input field
                'name' => 'due_days', // Name for the input field
            ]
        ];
    }

    // Apply action logic to set the due day and due date based on "Due Days"
    public static function applyAction(ContainerInterface $container, $entity, $value = null)
        {
            // Fetch the Doctrine Entity Manager
            $entityManager = $container->get('doctrine.orm.entity_manager');

            // Ensure entity is a Ticket and value is not empty
            if ($entity instanceof Ticket) {
                // Check if $value is an array and contains 'due_days'
                
                    // Convert due days to a float
                    $dueDays = (float)$value;
                    error_log("Due days set to: " . $value);
                    error_log(print_r($value, true));
                    // Only proceed if dueDays is a positive number
                    if ($dueDays > 0) {
                        // Calculate the due date by adding dueDays to the current date
                        $dueDate = (new \DateTime())->modify("+$dueDays days");
                        
                        // Update due_day and due_date in the entity
                        $entity->setDueDay($dueDays);
                        $entity->setDueDate($dueDate);

                        // Persist the ticket entity changes to the database
                        $entityManager->persist($entity);
                        $entityManager->flush();
                    
                    }
                    else if($dueDays == 0) {
                        $dueDate = (new \DateTime());
                        // Update due_day and due_date in the entity
                        $entity->setDueDay($dueDays);
                        $entity->setDueDate($dueDate);

                        // Persist the ticket entity changes to the database
                        $entityManager->persist($entity);
                        $entityManager->flush();
                    }
        }
}}
