<?php

namespace Webkul\UVDesk\CoreFrameworkBundle\Workflow\Actions\Ticket;

use Webkul\UVDesk\AutomationBundle\Workflow\FunctionalGroup;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Webkul\UVDesk\CoreFrameworkBundle\Entity\Ticket;
use Webkul\UVDesk\CoreFrameworkBundle\Entity\User;
use Webkul\UVDesk\AutomationBundle\Workflow\Action as WorkflowAction;

class UpdateAgent extends WorkflowAction
{
    public static function getId()
    {
        return 'uvdesk.ticket.assign_agent';
    }

    public static function getDescription()
    {
        return "Assign to agent";
    }

    public static function getFunctionalGroup()
    {
        return FunctionalGroup::TICKET;
    }

    public static function getOptions(ContainerInterface $container)
    {
        $agentCollection = array_map(function ($agent) {
            return [
                'id' => $agent['id'],
                'name' => $agent['name'],
            ];
        }, $container->get('user.service')->getAgentPartialDataCollection());

        array_unshift($agentCollection, [
            'id' => 'responsePerforming',
            'name' => 'Response Performing Agent',
        ]);

        array_unshift($agentCollection, [
            'id' => '0',
            'name' => 'Auto Assign',
        ]);

        return $agentCollection;
    }

    public static function applyAction(ContainerInterface $container, $entity, $value = null)
    {
        $entityManager = $container->get('doctrine.orm.entity_manager');
        
        if ($entity instanceof Ticket) {
           
            if ($value == 'responsePerforming' && is_object($currentUser = $container->get('security.token_storage')->getToken()->getUser())) {
                if (null != $currentUser->getAgentInstance()) {
                    $agent = $currentUser;
                }
            }

            else if($value == '0')
            {
                $supportGroupId = null; // Set this as needed
                $supportTeamId = null; // Set this as needed
                $supportGroup = $entity->getSupportGroup();
    
                // Check if the support group is not null
                if ($supportGroup !== null) {
                    // Assuming the support group object has a method called getId to get the ID
                    $supportGroupId = $supportGroup->getId();
                } 

                $supportTeam = $entity->getSupportTeam();
                if ($supportTeam !== null) {
        // Assuming the support team object has a method called getId to get the ID
                      $supportTeamId = $supportTeam->getId();
                } 

               
                $agentId = self::getAgentWithLeastTickets($entityManager, $supportGroupId, $supportTeamId);

                $agent = $entityManager->getRepository(User::class)->find($agentId);
            }

            else {
                $agent = $entityManager->getRepository(User::class)->find($value);

                if ($agent) {
                    $agent = $entityManager->getRepository(User::class)->findOneBy(array('email' => $agent->getEmail()));
                }
            }

            if (!empty($agent)) {
                if ($entityManager->getRepository(User::class)->findOneBy(array('id' => $agent->getId()))) {
                    $entity->setAgent($agent);
                    $entityManager->persist($entity);
                    $entityManager->flush();
                }
            } else {
                // Agent Not Found. Disable Workflow/Prepared Response
            }
        }
    }

    public static function getAgentWithLeastTickets($entityManager, $supportGroupId, $supportTeamId) {
        $conn = $entityManager->getConnection();
        $sql = "CALL GetTopAgent(:supportGroupId, :supportTeamId)";
        
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':supportGroupId', $supportGroupId);
        $stmt->bindParam(':supportTeamId', $supportTeamId);
        
        $stmt->execute();
        
        $result = $stmt->fetch();
        return $result["user_id"]; // Assuming the stored procedure returns the result column
    }
    
}
